//===============================================
// HitListBinocs
//===============================================
Class HitListBinocs extends WeaponRifle;

Var DeusExPlayer ConfPlayer;
Var CozPlayerEditMutator CPEM;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
	return( (BeltSpot >= 1) && (BeltSpot <=9) );
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z) 
{
	local int i;

	if(Other.IsA('DeusExPlayer'))
	{
		if(ConfPlayer == None)
		{
			for (i=1; i<10; i++)
			{
				if(CPEM.ClientH[i] == DeusExPlayer(owner))
				{
					if(CPEM.PriceOnHead[i] != 0)
					{
						if((CPEM.Victim[i] == None)) //1 per person
						{
							//CPEM.Victim[i] == DeusExPlayer(Other);
							ConfPlayer = DeusExPlayer(Other);
							SetTimer(5.0, false);
							DeusExPlayer(Owner).ClientMessage("|p2You're about to put a hit on "$DeusExPlayer(Other).PlayerReplicationInfo.PlayerName$" for "$CPEM.PriceOnHead[i]$" credits. Are you sure? Tag them again to confirm.");
							return;
						}
						else
						{
							DeusExPlayer(Owner).ClientMessage("|p2You've already placed a hit on "$CPEM.Victim[i].PlayerReplicationInfo.PlayerName$". Use 'mutate hit clear' to remove a previous hit.");
						}
					}
					else
					{
						DeusExPlayer(Owner).ClientMessage("|p2You haven't set a price for the hit!");
						return;
					}
				}
			}
		}
		else
		{
			for(i=1; i<10; i++)
			{
				if(DeusExPlayer(Owner) == CPEM.ClientH[i])
				{
					if(CPEM.Victim[i] == None)
					{
						if(DeusExPlayer(Owner).Credits >= CPEM.PriceOnHead[i])
						{
							DeusExPlayer(Owner).Credits -= CPEM.PriceOnHead[i];
							CPEM.Victim[i] = DeusExPlayer(Other);
							DeusExPlayer(Owner).ClientMessage("|p2You placed a hit on "$CPEM.Victim[i].PlayerReplicationInfo.PlayerName$" for "$CPEM.PriceOnHead[i]$" credits.");
							BroadcastMessage("|p2Hitlist updated.");
							CPEM.paidto[i] = CPEM.PriceOnHead[i];
							ConfPlayer = None;
						}
						else
						{
							DeusExPlayer(owner).ClientMessage("|p2You don't have the "$CPEM.PriceOnHead[i]$" credits on you to place that hit.");
						}
					}
					else
					{
						DeusExPlayer(Owner).ClientMessage("|p2You've already placed a hit on "$CPEM.Victim[i].PlayerReplicationInfo.PlayerName$". Go to the hospital to find out how to remove a previous hit.");
					}
				}
			}
		}
	}
	else
	{
		DeusExPlayer(Owner).ClientMessage("|p2That's not a player.");
	}
}

function Timer()
{
	if(ConfPlayer != None)
	{
		DeusExPlayer(Owner).ClientMessage("|p2Cancelled the hit on "$ConfPlayer.PlayerReplicationInfo.PlayerName);
		ConfPlayer = None;
	}
}

function BringUp()
{
	local CozPlayerEditMutator CPEMM;

	if(CPEM == None)
	{
		foreach AllActors(class'CozPlayerEditMutator',CPEMM)
		{
			CPEM = CPEMM;
		}
	}

	Super.BringUp();
}

defaultproperties
{
     inventorygroup=243
     NoiseLevel=0.010000
     Concealability=CONC_All
     FireSound=Sound'DeusExSounds.Weapons.StealthPistolReloadEnd'
     mphitdamage=0 //just in case
     reloadTime=10.000000
     ReloadCount=1
     ItemName="Hitlist Binoculars"
     ItemArticle="some"
     PlayerViewOffset=(X=18.000000,Z=-6.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Binoculars'
     PickupViewMesh=LodMesh'DeusExItems.Binoculars'
     ThirdPersonMesh=LodMesh'DeusExItems.Binoculars'
     LandSound=Sound'DeusExSounds.Generic.PaperHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconBinoculars'
     largeIcon=Texture'DeusExUI.Icons.LargeIconBinoculars'
     largeIconWidth=49
     largeIconHeight=34
     Description="A pair of special binoculars."
     beltDescription="HITLIST"
     Mesh=LodMesh'DeusExItems.Binoculars'
     CollisionRadius=7.000000
     CollisionHeight=2.060000
     Mass=5.000000
     Buoyancy=6.000000
}
